%This script generates Fig. 10, composed of four panels.

%In every panel, we plot the average quoted spread across K=1,000
%experiments, together with +/- 1 s.d. bands. We simulate T1 = 1,000,000
%episodes with Delta_v = 4. Then for Ts = 1,000 episodes Delta_v switches
%to a new value Delta_v'. Finally, for T2 = 1,000,000 - Ts episodes we
%switch back to Delta_v.

%Panel A: Average quoted spread over episodes 1 to T1+T2, with Delta_v' = 7.

%Panel B: Average quoted spread over episodes T1-1000 to T1+10,000, with Delta_v' = 7.

%Panel C: Average quoted spread over episodes 1 to T1+T2, with Delta_v' = 4 (Placebo).

%Panel D: Average quoted spread over episodes 1 to T1+T2, with Delta_v' = 1.


%%Panel A and B: Shock with Delta_v' = 7
% Create the name of the baseline case dataset to be loaded
dataname = sprintf('Data/av_all_episodes_Deltav_7_Ts_1000.txt');
% Load the workspace
av_all_episodes = readmatrix(dataname);

T1=1000000;  %T1 is the number of episodes before the shock.
Ts = 1000;   %Ts is the length of the shock.
T2 = 10^6-Ts;%T2 is the after shock period
xall = (1:T1+Ts+T2)';
xzoom = (1:11001)';

% AVERAGE QUOTED SPREAD OVER EPISODES - All episodes
figure(1)

% plot average quoted spreads

plot(xall,av_all_episodes(:,7)-2 ,'color',[0.8 0.4 0])
hold on

% plot +/- 1 s.d. bands
upper = av_all_episodes(:,7)-2 + sqrt(av_all_episodes(:,14)-av_all_episodes(:,7).^2);  
lower = av_all_episodes(:,7)-2 - sqrt(av_all_episodes(:,14)-av_all_episodes(:,7).^2);  
plot(xall,upper)
plot(xall,lower)
%highlight the interval
fill([xall; flipud(xall)], [upper; flipud(lower)], [0.9 0.9 0.9]);

plot(xall,av_all_episodes(:,7)-2 ,'color',[0.8 0.4 0])

ylim([0,7]);
xline(T1,'-',{'Shock'});

% set legend
legend('', '', 'Average', '$\pm$ 1 s.d.', '','interpreter', 'latex', 'location', 'northwest')
legend('boxoff')
ylabel('Quoted Spread')
xlabel('Episodes')

%hide right and top figure borders
ax = gca;
ax.Box = 'off';

%save png

filename = sprintf('/Figures/Fig_10_a.png');
saveas(figure(1), [pwd filename]);

hold off

% AVERAGE QUOTED SPREAD OVER EPISODES - Zoom around shock
figure(2)

% plot average quoted spreads
plot(xzoom,av_all_episodes(T1-1000:T1+10000,7)-2 ,'color',[0.8 0.4 0])
hold on

% plot +/- 1 s.d. bands
upper = av_all_episodes(T1-1000:T1+10000,7)-2 + sqrt(av_all_episodes(T1-1000:T1+10000,14)-av_all_episodes(T1-1000:T1+10000,7).^2);  
lower = av_all_episodes(T1-1000:T1+10000,7)-2 - sqrt(av_all_episodes(T1-1000:T1+10000,14)-av_all_episodes(T1-1000:T1+10000,7).^2);  
plot(xzoom,upper)
plot(xzoom,lower)
%highlight the interval
fill([xzoom; flipud(xzoom)], [upper; flipud(lower)], [0.9 0.9 0.9]);

plot(xzoom,av_all_episodes(T1-1000:T1+10000,7)-2 ,'color',[0.8 0.4 0])

ylim([0,7]);
xline(1000,'-',{'Shock'});

% set legend
legend('', '', 'Average', '$\pm$ 1 s.d.', '', 'interpreter', 'latex', 'location', 'northeast')
legend('boxoff')
ylabel('Quoted Spread')
xlabel('Episodes relative to $T_1$','interpreter', 'latex')

xticks([0 1000 2000 6000 11000])
xticklabels({'-1000','0','1000','5000','10000'})

%hide right and top figure borders
ax = gca;
ax.Box = 'off';

%save png
filename = sprintf('/Figures/Fig_10_b.png');
saveas(figure(2), [pwd filename]);

hold off

%%Panel D: Shock with Delta_v' = 1
% Create the name of the baseline case dataset to be loaded
dataname = sprintf('Data/av_all_episodes_Deltav_1_Ts_1000.txt');
% Load the workspace
av_all_episodes = readmatrix(dataname);

% AVERAGE QUOTED SPREAD OVER EPISODES - All episodes
figure(3)

% plot average quoted spreads

plot(xall,av_all_episodes(:,7)-2,'color',[0.8 0.4 0])
hold on

% plot +/- 1 s.d. bands
upper = av_all_episodes(:,7)-2 + sqrt(av_all_episodes(:,14)-av_all_episodes(:,7).^2);  
lower = av_all_episodes(:,7)-2 - sqrt(av_all_episodes(:,14)-av_all_episodes(:,7).^2);  
plot(xall,upper)
plot(xall,lower)
%highlight the interval
fill([xall; flipud(xall)], [upper; flipud(lower)], [0.9 0.9 0.9]);

plot(xall,av_all_episodes(:,7)-2 ,'color',[0.8 0.4 0])

ylim([0,7]);
xline(T1,'-',{'Shock'});

% set legend
legend('', '', 'Average', '$\pm$ 1 s.d.', '','interpreter', 'latex', 'location', 'northwest')
legend('boxoff')
ylabel('Quoted Spread')
xlabel('Episodes')

%hide right and top figure borders
ax = gca;
ax.Box = 'off';

%save png

filename = sprintf('/Figures/Fig_10_d.png');
saveas(figure(3), [pwd filename]);

hold off

%%Panel C: Delta_v' = 4
% Create the name of the baseline case dataset to be loaded
dataname = sprintf('Data/av_all_episodes_Placebo.txt');
% Load the workspace
av_all_episodes = readmatrix(dataname);   

% AVERAGE QUOTED SPREAD OVER EPISODES - All episodes
figure(4)

% plot average quoted spreads
plot(xall,av_all_episodes(:,7)-2,'color',[0.8 0.4 0])
hold on

% plot +/- 1 s.d. bands
upper = av_all_episodes(:,7)-2 + sqrt(av_all_episodes(:,14)-av_all_episodes(:,7).^2);  
lower = av_all_episodes(:,7)-2 - sqrt(av_all_episodes(:,14)-av_all_episodes(:,7).^2);  
plot(xall,upper)
plot(xall,lower)
%highlight the interval
fill([xall; flipud(xall)], [upper; flipud(lower)], [0.9 0.9 0.9]);

plot(xall,av_all_episodes(:,7)-2,'color',[0.8 0.4 0])

ylim([0,7]);
xline(T1,'-',{'Shock'});

% set legend
legend('', '', 'Average', '$\pm$ 1 s.d.', '','interpreter', 'latex', 'location', 'northwest')
legend('boxoff')
ylabel('Quoted Spread')
xlabel('Episodes')

%hide right and top figure borders
ax = gca;
ax.Box = 'off';

%save png

filename = sprintf('/Figures/Fig_10_c.png');
saveas(figure(4), [pwd filename]);

hold off
